CREATE OR REPLACE FUNCTION alterView() 
RETURNS VOID AS 
$BODY$ 
DECLARE
	msgFinal text := 'CRIADA';
BEGIN 
IF EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'v_pdv_vd_est_prod') THEN 
						 
	DROP VIEW v_pdv_vd_est_prod;
    RAISE NOTICE 'Visão v_pdv_vd_est_prod FOI REMOVIDA';                             
    msgFinal := 'RECRIADA'::text;
END IF; 


CREATE OR REPLACE VIEW public.v_pdv_vd_est_prod
AS SELECT est_prod.ds_prod,
    est_prod_cpl.cd_emp,
    est_prod_cpl.cd_filial,
    est_prod_cpl.cd_prod,
    est_prod_cpl.qt_est,
    est_prod_cpl.cd_trib_vd,
    est_prod_cpl.perc_icms_n_cont_esta,
    est_prod_cpl.perc_red_vd,
	est_prod.prod_excessao_fecop,
    est_prod_cpl.perc_fcp,
    est_prod_cpl.perc_fecop_st,
    est_prod_cpl.perc_fecop_ret,
    est_prod_cpl.perc_red_base_calc_efet,
    est_prod_cpl.perc_icms_efet,
    est_prod_cpl.perc_icms_ret,
    est_prod_cpl.cd_benef,
    NULLIF(est_prod_preco.vlr_tabela, 0::numeric) AS vlr_tabela,
    NULLIF(est_prod_preco.vlr_oferta, 0::numeric) AS vlr_oferta,
    est_trib.cd_trib_fc,
    est_prod_cpl.tp_prod,
    est_prod_cpl.qtde_ponto_fidel,
    est_prod.flag_prod_kit,
    NULLIF(est_prod_cpl.perc_ibpt, 0::numeric) AS tx_imposto,
    COALESCE(est_prod.ncm_prod, ''::character varying) AS ncm_prod,
    COALESCE(est_prod_cpl.icms, 0::numeric) AS icms,
    COALESCE(est_prod_cpl.subs_trib, 0::numeric) AS subs_trib,
    COALESCE(est_prod_cpl.icms_rd, 0::numeric) AS icms_rd,
    COALESCE(est_prod_cpl.isento, 0::numeric) AS isento,
    COALESCE(est_prod_cpl.subs_trib_ant, 0::numeric) AS subs_trib_ant,
    COALESCE(est_prod_cpl.flag_outros, 0::numeric) AS flag_outros,
    COALESCE(est_trib.tipo_regime_empresa::numeric, 0::numeric) AS tipo_regime_empresa,
    est_prod_cpl.motivo_desonerado_icms,
        CASE
            WHEN est_trib.icms_desonerado = 1::numeric AND est_prod_cpl.icms_desonerado = 1::numeric THEN 1
            ELSE 0
        END AS icms_desonerado,
    est_prod.origem_produto,
    COALESCE(est_prod.nr_cest, ''::character varying) AS nr_cest,
    COALESCE(est_prod_cpl.vlr_base_calc_efet, 0::numeric) AS vlr_base_calc_efet,
    COALESCE(est_prod_cpl.vlr_icms_efet, 0::numeric) AS vlr_icms_efet
   FROM est_prod
     JOIN est_prod_cpl ON est_prod.cd_emp = est_prod_cpl.cd_emp AND est_prod.cd_prod = est_prod_cpl.cd_prod
     JOIN est_trib ON est_prod_cpl.cd_trib_vd = est_trib.cd_trib
     LEFT JOIN est_prod_preco ON est_prod_cpl.cd_emp = est_prod_preco.cd_emp AND est_prod_cpl.cd_filial = est_prod_preco.cd_filial AND est_prod_cpl.cd_prod = est_prod_preco.cd_prod;  

  RAISE NOTICE 'Visão v_pdv_vd_est_prod FOI %', msgFinal::varchar;

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION alterView() OWNER TO postgres; 
SELECT alterView(); 
DROP FUNCTION alterView();